/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.test;

import filenet.vw.integrator.adaptors.webservices.WSInvokeOperation;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class WSInvokeTest {
    private static void printUsage(String errMsg) {
        if (errMsg != null) {
            System.err.println(errMsg);
        }
        System.out.println("WSInvokeTest /endPoint=xxx /portType=xxx /operation=xxxx /inText=xxx");
        System.out.println("  OR /endpoint=xxx /portType=xxxx /operation=xxxx /inFile=xxxx");
        System.out.println("  OR /inputfile=xxxx ");
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h") || c.isPresent("?") || c.isPresent("H")) {
                WSInvokeTest.printUsage(null);
            }
            if (c.isPresent("inputfile")) {
                String inputFile = c.getParameter("inputfile");
                c = new VWCommandLineArgs(inputFile, false);
            }
            String endPoint = c.getParameter("endPoint");
            String portType = c.getParameter("portType");
            String operation = c.getParameter("operation");
            String inputMessage = null;
            if (c.isPresent("inText")) {
                inputMessage = c.getParameter("inText");
            } else if (c.isPresent("inFile")) {
                inputMessage = WSInvokeTest.getFileContents(c.getParameter("inFile"));
            }
            if (endPoint == null) {
                WSInvokeTest.printUsage("endPoint is not specified.");
            }
            if (portType == null) {
                WSInvokeTest.printUsage("portType is not specified");
            }
            if (operation == null) {
                WSInvokeTest.printUsage("oepration is not specified");
            }
            if (inputMessage == null) {
                WSInvokeTest.printUsage("no inputmessage!");
            }
            WSInvokeOperation testInvoke = new WSInvokeOperation(null, null, 30000, true, null, 0L, 0L, null, false, 1, "qdang", "abcd");
            testInvoke.invokeTest(endPoint, portType, operation, inputMessage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getFileContents(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            System.err.println(fileName + " does not exist!");
            throw new FileNotFoundException(fileName);
        }
        FileInputStream inStream = new FileInputStream(f);
        int size = inStream.available();
        byte[] b = new byte[size];
        inStream.read(b);
        String res = new String(b);
        return res;
    }
}

